;;   Le fichier ann.01.CLOS doit avoir t charg pralablement.

;;; Exemples d'oprations logiques lmentaires  un, trois et quatre oprandes,
;;; constituant toutes des cas *linairement sparables*

;;   Charger ce fichier, puis valuer manuellement parmi les dernires lignes...

;;   Dfinition d'une instance de perceptron  un stimulus, destine 
;; reproduire l'opration de ngation.
;;   Pour <n> oprandes, une instance comporte toujours <n>+1 pondrations, 
;; cause de celle du biais constant  1.

(setq pNOT  (make-instance 'perceptron :nom "pNOT"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 2)))

;;   Dfinition d'instances de perceptrons  trois et quatre oprandes,
;; destines  reproduire l'opration AND.

(setq pAND3 (make-instance 'perceptron :nom "pAND3"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 4)))
(setq pAND4 (make-instance 'perceptron :nom "pAND4"
                                       :Ws  (faire-liste '(corect -1.0 1.0) 5)))

;;   Impression des performances des perceptrons aux divers exemples.
;; L'objectif est cit aprs chaque combinaison de stimuli. Leurs pondrations
;; initiales tant alatoires, les perceptrons ne peuvent pas donner
;; satisfaction ds leur cration...

(performe pNOT           '(((-1)  1)
                           (( 1) -1)) :print t)
(performe pAND3    '(((-1 -1 -1) -1)
                     ((-1 -1  1) -1)
                     ((-1  1 -1) -1)
                     ((-1  1  1) -1)
                     (( 1 -1 -1) -1)
                     (( 1 -1  1) -1)
                     (( 1  1 -1) -1)
                     (( 1  1  1)  1)) :print t)
(performe pAND4 '(((-1 -1 -1 -1) -1)
                  ((-1 -1 -1  1) -1)
                  ((-1 -1  1 -1) -1)
                  ((-1 -1  1  1) -1)
                  ((-1  1 -1 -1) -1)
                  ((-1  1 -1  1) -1)
                  ((-1  1  1 -1) -1)
                  ((-1  1  1  1) -1)
                  (( 1 -1 -1 -1) -1)
                  (( 1 -1 -1  1) -1)
                  (( 1 -1  1 -1) -1)
                  (( 1 -1  1  1) -1)
                  (( 1  1 -1 -1) -1)
                  (( 1  1 -1  1) -1)
                  (( 1  1  1 -1) -1)
                  (( 1  1  1  1)  1)) :print t)

;;   Evaluer manuellement parmi les formes ci-dessous, au besoin...

;(Ws? pNOT) (Ws? pAND3) (Ws? pAND4)

;(tire pNOT '(-1)) (tire pNOT '(1))
;(tire pAND3 '(-1 -1 -1)) (tire pAND3 '( 1 -1 1)) (tire pAND3 '( 1  1 -1)) (tire pAND3 '( 1  1  1))
;(tire pAND4 '(-1 -1 -1 -1)) (tire pAND4 '(-1  1 -1  1)) (tire pAND4 '( 1  1  1 -1)) (tire pAND4 '( 1  1  1  1))

;;   Demander poliment aux perceptrons de faire leur apprentissage...

;(apprend pNOT '(((-1)  1) (( 1) -1)))
;(apprend pAND3 '(((-1 -1 -1) -1) ((-1 -1  1) -1) ((-1  1 -1) -1) ((-1  1  1) -1) (( 1 -1 -1) -1) (( 1 -1  1) -1) (( 1  1 -1) -1) (( 1  1  1)  1)))
;(apprend pAND4 '(((-1 -1 -1 -1) -1) ((-1 -1 -1  1) -1) ((-1 -1  1 -1) -1) ((-1 -1  1  1) -1) ((-1  1 -1 -1) -1) ((-1  1 -1  1) -1) ((-1  1  1 -1) -1) ((-1  1  1  1) -1) (( 1 -1 -1 -1) -1) (( 1 -1 -1  1) -1) (( 1 -1  1 -1) -1) (( 1 -1  1  1) -1) (( 1  1 -1 -1) -1) (( 1  1 -1  1) -1) (( 1  1  1 -1) -1) (( 1  1  1  1)  1)))

;;   Rvaluer ensuite les mthodes performe d'impression ci-dessus...